/*
 * Decompiled with CFR 0.152.
 */
package view;

import data.Debugging;
import data.Theme;
import java.awt.Color;
import java.util.ArrayList;
import org.lwjgl.opengl.GL11;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.UnicodeFont;
import org.newdawn.slick.font.effects.ColorEffect;

public class Fonts {
    private static ArrayList<ArrayList<UnicodeFont>> fontStyleList = new ArrayList();
    private static ArrayList<UnicodeFont> currentFont;
    static int[] fontSizes;
    private static int iStandardSize;
    public static float resolutionScale;
    private static String[] inputFontList;
    private static int[] iDefaultFontSize;
    private static int iCurrentFontNum;

    static {
        fontSizes = new int[]{12, 18, 24, 36, 48, 60, 72};
        iStandardSize = 48;
        resolutionScale = 1.0f;
        inputFontList = new String[]{"fonts/Base6.ttf", "fonts/Diehl Deco.ttf", "fonts/Locus.ttf", "fonts/autobahn.ttf", "fonts/Stereofunk.ttf"};
        iDefaultFontSize = new int[]{36, 36, 48, 36, 36};
        iCurrentFontNum = 0;
    }

    public static void initialize() {
        int iNumFonts = 1;
        if (Debugging.bDebugBuild) {
            iNumFonts = inputFontList.length;
        }
        int i = 0;
        while (i < iNumFonts) {
            String sFontName = inputFontList[i];
            try {
                ArrayList<UnicodeFont> fontSizeList = new ArrayList<UnicodeFont>();
                int j = 0;
                while (j < fontSizes.length) {
                    UnicodeFont unicodeFont = new UnicodeFont(sFontName, fontSizes[j], false, false);
                    unicodeFont.addAsciiGlyphs();
                    unicodeFont.addGlyphs(400, 600);
                    unicodeFont.getEffects().add(new ColorEffect(Color.WHITE));
                    unicodeFont.loadGlyphs();
                    fontSizeList.add(unicodeFont);
                    ++j;
                }
                fontStyleList.add(fontSizeList);
            }
            catch (SlickException e) {
                e.printStackTrace();
            }
            ++i;
        }
        currentFont = fontStyleList.get(iCurrentFontNum);
        iStandardSize = iDefaultFontSize[iCurrentFontNum];
    }

    public static void useNextFont() {
        ++iCurrentFontNum;
        currentFont = fontStyleList.get(iCurrentFontNum %= inputFontList.length);
        iStandardSize = iDefaultFontSize[iCurrentFontNum];
    }

    public static void usePreviousFont() {
        --iCurrentFontNum;
        if ((iCurrentFontNum %= inputFontList.length) < 0) {
            iCurrentFontNum = inputFontList.length - 1;
        }
        currentFont = fontStyleList.get(iCurrentFontNum);
        iStandardSize = iDefaultFontSize[iCurrentFontNum];
    }

    public static void drawText(float xInput, float yInput, double dScale, String sText, boolean bCenterText) {
        int xLoc = (int)xInput;
        int yLoc = (int)yInput;
        UnicodeFont unicodeFont = null;
        int iFontIndex = 0;
        int i = 0;
        while (i < fontSizes.length) {
            if ((double)iStandardSize * dScale * (double)resolutionScale <= (double)fontSizes[i]) {
                unicodeFont = currentFont.get(i);
                iFontIndex = i;
                break;
            }
            ++i;
        }
        float fFontScale = (float)((double)iStandardSize * dScale * (double)resolutionScale / (double)fontSizes[iFontIndex]);
        if (bCenterText) {
            xLoc = (int)((double)xLoc - (double)unicodeFont.getWidth(sText) / 2.0 * (double)fFontScale);
            yLoc = (int)((double)yLoc - (double)unicodeFont.getHeight(sText) / 2.0 * (double)fFontScale);
        }
        GL11.glBlendFunc(770, 771);
        GL11.glEnable(3553);
        GL11.glTexParameterf(3553, 10241, 9729.0f);
        GL11.glTexParameterf(3553, 10240, 9729.0f);
        GL11.glEnable(3042);
        GL11.glPushMatrix();
        GL11.glTranslated(xLoc, yLoc, 0.0);
        GL11.glScaled(fFontScale, fFontScale, fFontScale);
        unicodeFont.drawString(0.0f, 0.0f, sText, Theme.getThemeTextColor());
        GL11.glPopMatrix();
        GL11.glDisable(3042);
        GL11.glDisable(3553);
    }

    public static void drawText(float xInput, float yInput, double dScale, String sText, org.newdawn.slick.Color color, boolean bCenterText) {
        int xLoc = (int)xInput;
        int yLoc = (int)yInput;
        UnicodeFont unicodeFont = null;
        int iFontIndex = 0;
        int i = 0;
        while (i < fontSizes.length) {
            if ((double)iStandardSize * dScale * (double)resolutionScale <= (double)fontSizes[i]) {
                unicodeFont = currentFont.get(i);
                iFontIndex = i;
                break;
            }
            ++i;
        }
        float fFontScale = (float)((double)iStandardSize * dScale * (double)resolutionScale / (double)fontSizes[iFontIndex]);
        if (bCenterText) {
            xLoc = (int)((double)xLoc - (double)unicodeFont.getWidth(sText) / 2.0 * (double)fFontScale);
            yLoc = (int)((double)yLoc - (double)unicodeFont.getHeight(sText) / 2.0 * (double)fFontScale);
        }
        GL11.glBlendFunc(770, 771);
        GL11.glEnable(3553);
        GL11.glTexParameterf(3553, 10241, 9729.0f);
        GL11.glTexParameterf(3553, 10240, 9729.0f);
        GL11.glEnable(3042);
        GL11.glPushMatrix();
        GL11.glTranslated(xLoc, yLoc, 0.0);
        GL11.glScaled(fFontScale, fFontScale, fFontScale);
        unicodeFont.drawString(0.0f, 0.0f, sText, color);
        GL11.glPopMatrix();
        GL11.glDisable(3042);
        GL11.glDisable(3553);
    }

    public static float getWidth(String s, double dScale) {
        UnicodeFont unicodeFont = null;
        int iFontIndex = 0;
        int i = 0;
        while (i < fontSizes.length) {
            if ((double)iStandardSize * dScale * (double)resolutionScale <= (double)fontSizes[i]) {
                unicodeFont = currentFont.get(i);
                iFontIndex = i;
                break;
            }
            ++i;
        }
        float fFontScale = (float)((double)iStandardSize * dScale * (double)resolutionScale / (double)fontSizes[iFontIndex]);
        return (float)unicodeFont.getWidth(s) * fFontScale;
    }

    public static float getHeight(String s, double dScale) {
        String sFontName = inputFontList[iCurrentFontNum];
        if (sFontName.equals("fonts/Base6.ttf")) {
            dScale *= 0.75;
        }
        UnicodeFont unicodeFont = null;
        int iFontIndex = 0;
        int i = 0;
        while (i < fontSizes.length) {
            if ((double)iStandardSize * dScale * (double)resolutionScale <= (double)fontSizes[i]) {
                unicodeFont = currentFont.get(i);
                iFontIndex = i;
                break;
            }
            ++i;
        }
        float fFontScale = (float)((double)iStandardSize * dScale * (double)resolutionScale / (double)fontSizes[iFontIndex]);
        return (float)unicodeFont.getHeight(s) * fFontScale;
    }

    public static int whatFont() {
        return iCurrentFontNum;
    }
}

